/* Portwatch, by Mark Kamichoff [kamicm@rpi.edu] *
 * Original Filename: portwatch.c                *
 * Opens a TCP port and displays attempted       *
 * connections to it.                            */

#include <stdlib.h>
#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <time.h>
#include <signal.h>
#include <netdb.h>
#include <sys/utsname.h>

#define _UTS_NAMESIZE 16
#define _UTS_NODESIZE 256

#define SA struct sockaddr	/* Richard Stevens suggests this
				   and it makes life easier! */

int sockfd, clientfd;	/* Global socket file descriptors */

/* Sets up signal prototypes */

void signalterminate(void);
void signalinterrupt(void);

void signalterminate(void) {
	fputs("caught SIGTERM...exiting now...\n",stderr);
	close(sockfd);
	close(clientfd);
	fputs("closed client and server file descriptors...\n",stderr);
	exit(1);
}

void signalinterrupt(void) {
	fputs("caught SIGINT...exiting now...\n",stderr);
	close(sockfd);
	close(clientfd);
	fputs("closed client and server file descriptors...\n",stderr);
	exit(1);
}

int main(int argc, char **argv)
{
	socklen_t clientlength;
	struct sockaddr_in servaddr, clientaddress;
	struct hostent *hptr;
	struct utsname myname;
	time_t ticks;
//	char recvline[80];
	int i;	/* Counter */

        signal(SIGINT,(void *) signalinterrupt);         /* Setup signal handlers */
        signal(SIGTERM,(void *) signalterminate);

	printf("--- Portwatch - By Mark Kamichoff ---\n");

	if(argc != 2)
	{
		printf("Error: syntax is %s <port>\n",argv[0]);
		exit(1);
	}

	if(!((atoi(argv[1]) < 65537) && (atoi(argv[1]) > 0 )))
	{
		fputs("Error: Port number not valid (needs to be between 0 and 65536\n",stderr);
		exit(1);
	}

	/* Gets info about your local UNIX machine */

	if(uname(&myname) == -1)
	{
		printf("Something went real wrong...maybe you're not running UNIX?\n");
		exit(1);
	}

	printf("System Info: %s, Version %s, Architecture: %s\n\n",myname.sysname,
		myname.release,
		myname.machine);

	/* This will come out something like this:
	System Info: Linux, Version 2.4.17, Architecture: i686
	*/

	printf("Attempting to create socket...");
	if(!(sockfd = socket(AF_INET, SOCK_STREAM, 0)))
	{
		fputs("Error: Socket creation failed\n",stderr);
		exit(1);
	}
	printf("...success!\n");

	bzero(hptr, sizeof(hptr));	/* Clear contents of hptr */
	bzero(&servaddr, sizeof(servaddr));	/* Clear contents of servaddr */

	/* Set the local server address */

	servaddr.sin_family = AF_INET;	/* IP */
	servaddr.sin_addr.s_addr = htonl(INADDR_ANY);	/* Listens on all addresses */
	servaddr.sin_port = htons(atoi(argv[1]));	/* Sets the port */

	if(bind(sockfd, (SA *) &servaddr, sizeof(servaddr)) != 0)
	{
		fputs("Error: Bind() error, the port is probably in use\n",stderr);
		if(atoi(argv[1]) < 1024)
			fputs("Note: Since you chose a port <1024, you need root for this\n",stderr);
		exit(1);
	}

	/* Set the socket to listen for a connection */
	if(listen(sockfd, 5) != 0)
	{
		fputs("Error: Call to listen() failed, maybe your socket broke in two?\n",stderr);
		exit(1);
	}

	/* Just saying obvious stuff... */
	printf("Listening on port %s of all local interfaces\n",argv[1]);

	for(i=0;i<80;++i)	/* Drawing the bar, heh */
		fputs("-",stdout);

	printf("\n",argv[1]);

	while(1)	/* Keeps accepting connections until termination */
	{
		clientlength = sizeof(clientaddress);
		clientfd = accept(sockfd, (SA *) &clientaddress, &clientlength);

		ticks = time(NULL);	/* Get Current Time */

		hptr = gethostbyaddr((struct in_addr *) &clientaddress.sin_addr,
			sizeof(clientaddress.sin_addr),
			AF_INET);

		if(hptr == NULL)
			fputs("gethostbyname returned NULL\n",stderr);

		printf("Got a connection from %s:%d [%s] at %.24s\r\n",
			hptr->h_name,
			ntohs(clientaddress.sin_port),
			inet_ntoa(clientaddress.sin_addr),
			ctime(&ticks));
	}

	exit(0);	/* This will only be executed when there is an error
	                   opening the socket and/or port */
}
